% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid.R
\name{hybrid}
\alias{hybrid}
\title{hybrid}
\usage{
hybrid(m1i, m2i, mi, ri, sd1i, sd2i, sdi, n1i, n2i, ni, tobs, alpha, side)
}
\arguments{
\item{m1i}{A vector of means in group 1 for two-independent means}

\item{m2i}{A vector of means in group 2 for two-independent means}

\item{mi}{A vector of group means for one-sample means}

\item{ri}{A vector of raw correlations}

\item{sd1i}{A vector of standard deviations in group 1 for two-independent
means}

\item{sd2i}{A vector of standard deviations in group 2 for two-independent
means}

\item{sdi}{A vector of standard deviations for one-sample means}

\item{n1i}{A vector of sample sizes in group 1 for two-independent means}

\item{n2i}{A vector of sample sizes in group 2 for two-independent means}

\item{ni}{A vector of sample sizes for one-sample means and correlations}

\item{tobs}{A vector of t-values}

\item{alpha}{A integer specifying the alpha level as used in the original
study (default is 0.05).}

\item{side}{A character indicating whether the observed effect size of the
original study is in the right-tail of the distribution (i.e., positive) or
in the left-tail of the distribution (i.e., negative) (either \code{"right"}
or \code{"left"})}
}
\value{
\item{est.hy}{effect size estimate of hybrid method}
\item{ci.lb.hy}{lower bound of hybrid method's confidence interval}
\item{ci.ub.hy}{upper bound of hybrid method's confidence interval}
\item{x.hy}{test statistic of hybrid method's test of null-hypothesis of no
effect}
\item{pval.hy}{two-tailed p-value of hybrid method's test of null-hypothesis
 of no effect}
\item{measure}{effect size measure}
\item{est.hyr}{effect size estimate of hybridR method}
\item{ci.lb.hyr}{lower bound of hybridR method's confidence interval}
\item{ci.ub.hyr}{upper bound of hybridR method's confidence interval}
\item{stat.hyr}{test statistic of hybridR method's test of null-hypothesis of
 no effect}
\item{pval.hyr}{two-tailed p-value of hybridR method's test of
null-hypothesis of no effect}
\item{pval.o}{two-tailed p-value of original study}
\item{est.hy0}{effect size estimate of hybrid0 method}
\item{ci.lb.hy0}{lower bound of hybrid0 method's confidence interval}
\item{ci.ub.hy0}{upper bound of hybrid0 method's confidence interval}
\item{x.hy0}{test statistic of hybrid0 method's test of null-hypothesis of no
effect}
\item{pval.hy0}{two-tailed p-value of hybrid0 method's test of
null-hypothesis of no effect}
\item{est.fe}{effect size estimate based on traditional fixed-effect
meta-analysis}
\item{se.fe}{standard error of effect size estimate based on traditional
fixed-effect meta-analysis}
\item{zval.fe}{test statistic of the null-hypothesis of no effect based on
traditional fixed-effect meta-analysis}
\item{pval.fe}{two-tailed p-value of the null-hypothesis of no effect based
on traditional fixed-effect meta-analysis}
\item{ci.lb.fe}{lower bound of confidence interval based on traditional
fixed-effect meta-analysis}
\item{ci.ub.fe}{upper bound of confidence interval based on
traditional fixed-effect meta-analysis}
\item{est.repl}{effect size estimate of replication}
\item{se.repl}{standard error of replication's effect size estimate}
\item{ci.lb.repl}{lower bound of replication's confidence interval}
\item{ci.ub.repl}{upper bound of replication's confidence interval}
\item{stat.repl}{test statistic of replication for testing null-hypothesis of
 no effect}
\item{pval.repl}{two-tailed p-value of replication for testing
null-hypothesis of no effect}
}
\description{
Function to statistically combine an original study and replication by means
of the hybrid methods and fixed-effect meta-analysis as described in van Aert
and van Assen (2017).
\cr
\cr
Please note that this package is still under development and that this is a
beta version. If you suspect a bug, please send me an email
(\email{R.C.M.vanAert@tilburguniversity.edu}).
}
\details{
Three different effect sizes can be used as input for the
\code{hybrid} function: one-sample means, two-independent means, and raw
correlation coefficients. Analyzing one-sample means and two-independent
means can be done by either providing the function group means (\code{mi} or
\code{m1i} and \code{m2i}), standard deviations (\code{sdi} or \code{sd1i}
and \code{sd2i}), and sample sizes (\code{ni} or \code{n1i} and \code{n2i})
or t-values (\code{tobs}) and sample sizes (\code{ni} or \code{n1i}
and \code{n2i}). Both options should be accompanied with input for the
arguments \code{side} and \code{method}. See the Example section for an
example. Raw correlation coefficients can be analyzed by supplying \code{ri}
 and \code{ni} to the \code{puniform} function next to input for the
arguments \code{side} and \code{method}. The vectors containing data of the
original study and replication should always be of length two; the first
element should contain information about the original study and the second
element should contain information about the replication.

The hybrid methods assume that the original study is statistically
significant and a two-tailed hypothesis test was conducted in the original
study. In case a one-tailed hypothesis tests was conducted in the original
study, the alpha level has to be multiplied by two. For example, if a
one-tailed hypothesis test was conducted with an alpha level of .05, an alpha
 of 0.1 has to be entered into the \code{hybrid} function.
}
\examples{
### Apply hybrid function to example on page 5 of van Aert and van Assen (2017).

hybrid(tobs = c(2.211,1.04), n1i = c(40,80), n2i = c(40,80), alpha = .05, side = "right")

}
\references{
van Aert, R. C. M., & van Assen, M. A. L. M. (2017). Examining
reproducibility in psychology: A hybrid method for statistically combining a
biased original study and replication. Behavior Research Methods. doi:10.3758/s13428-017-0967-6
}
\author{
Robbie C.M. van Aert \email{R.C.M.vanAert@tilburguniversity.edu}
}
