% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_functions.R
\name{cross_tbl}
\alias{cross_tbl}
\title{Table of descriptive statistics by categorical variable.}
\usage{
cross_tbl(
  data,
  by,
  head_label = " ",
  bold = TRUE,
  show_total = TRUE,
  p_val = FALSE,
  pad = 3,
  method = 2,
  ...
)
}
\arguments{
\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{by}{The quoted name of the  categorical variable (factor) used for the stratification.}

\item{head_label}{Character, label to be used as head for the variable's column.}

\item{bold}{Display labels in bold?}

\item{show_total}{Logical, show column with totals?}

\item{p_val}{Logical, show p-values?}

\item{pad}{Numerical, padding above and bellow rows.}

\item{method}{An integer indicating methods for continuous variables.
1 Reports means and standard deviations.
2 Reports medians and interquartile ranges.}

\item{...}{Additional arguments passed to \code{\link[gtsummary]{tbl_summary}}.}
}
\value{
A huxtable with descriptive statistics stratified by levels of the outcome.
}
\description{
\code{cross_tbl} is a wrapper to function  from package \code{\link[gtsummary]{tbl_summary}} that constructs tables of descriptive statistics stratified by levels of a categorical outcome.
}
\details{
Function \code{cross_tbl} is a relatively simple wrapper to function \code{\link[gtsummary]{tbl_summary}}. It constructs contingency tables and can also be used to report a table with descriptives for all variables stratified by one of the variables. Please see examples to see how to list variables. If data is labelled, the label of the stratifying variable is used as part of the header.
}
\examples{
require(dplyr, quietly = TRUE)

#' data(Oncho)

## A two by two contingency table:
Oncho |>
  select(mf, area) |>
  cross_tbl(by = "mf", bold = TRUE) |>
  theme_pubh(2)

## Reporting prevalence:
Oncho |>
  select(mf, area) |>
  cross_tbl(by = "area", bold = TRUE) |>
  theme_pubh(2)

## Descriptive statistics for all variables in the \code{Oncho} data set except \code{id}.
Oncho |>
  select(-id) |>
  cross_tbl(by = "mf", bold = TRUE) |>
  theme_pubh(2)
}
\seealso{
\code{\link[gtsummary]{tbl_summary}}
}
