% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Macmahon}
\alias{Macmahon}
\title{Breast cancer and age of childbirth.}
\format{
A labelled tibble with 185 rows and 2 variables:
\describe{
\item{cancer}{Diagnosed with breast cancer, a factor with levels "No" and "Yes".}
\item{age}{Age mother gives childbirth, factor with levels "<20", "20-24",
"25-29", "30-34" and ">34".}
}
}
\source{
Macmahon, B. et al. (1970). Age at first birth and breast cancer risk. Bull WHO 43, 209-221.
}
\usage{
Macmahon
}
\description{
An international case-control study to test the hypothesis that breast
cancer is related to the age that a woman gives childbirth.
}
\examples{
require(dplyr, quietly = TRUE)
data(Macmahon)

Macmahon \%>\%
  select(cancer, age) \%>\%
  cross_tbl(by = "cancer")
}
\keyword{datasets}
