% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct_object_to_html.R
\name{dct_object_to_html}
\alias{dct_object_to_html}
\title{Create an HTML fragment showing a DCT object}
\usage{
dct_object_to_html(
  dctObject,
  headingLevel = 3,
  hyperlink_UCIDs = TRUE,
  collapseButtons = TRUE,
  urlPrefix = "#",
  sortDecreasing = FALSE
)
}
\arguments{
\item{dctObject}{The DCT object}

\item{headingLevel}{The level of the heading in the Markdown output
that is produces.}

\item{hyperlink_UCIDs}{Whether to create hyperlinks to UCIDs.}

\item{collapseButtons}{Whether to include buttons to show/hide the definition
and instructions.}

\item{urlPrefix}{The prefix to insert before the URL in the produced
hyperlink. The default, "\verb{#}", results in a link to an
anchor (an HTML \code{a} element) on the current page.}

\item{sortDecreasing}{Whether to sort the constructs in decreasing order
(\code{TRUE}), in increasing order (\code{FALSE}), or not at all (\code{NULL}).}
}
\value{
A character vector.
}
\description{
Create an HTML fragment showing a DCT object
}
\examples{
exampleDCT <-
  psyverse::dct_object(
    prefix = "exampleConstruct",
    label = "An example construct",
    definition = "The definition goes here",
    measure_dev = "Here you can explain how to measure the construct"
  );
### Only run this in an interactive R session,
### as it shows the HTML in the viewer.
if (interactive()) {
  dct_object_to_html(exampleDCT);
}
}
