% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{standardize.glm}
\alias{standardize.glm}
\title{Standardize Coefficients.}
\usage{
\method{standardize}{glm}(x, method = "refit", ...)
}
\arguments{
\item{x}{A linear model.}

\item{method}{The standardization method. Can be "refit" (will entirely refit the model based on standardized data. Can take some time) or "agresti".}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Compute standardized coefficients.
}
\examples{
\dontrun{
library(psycho)
fit <- glm(Sex ~ Adjusting, data = psycho::affective, family = "binomial")
fit <- lme4::glmer(Sex ~ Adjusting + (1 | Sex), data = psycho::affective, family = "binomial")

standardize(fit)
}

}
\seealso{
https://think-lab.github.io/d/205/
}
\author{
Kamil Barton
}
