% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.stanreg.R
\name{analyze.stanreg}
\alias{analyze.stanreg}
\title{Analyze stanreg objects.}
\usage{
\method{analyze}{stanreg}(x, CI = 95, effsize = FALSE, verbose = T, ...)
}
\arguments{
\item{x}{stanreg object.}

\item{CI}{Credible interval bounds.}

\item{effsize}{Compute Effect Sizes according to Cohen (1988)? Your outcome variable must be standardized.}

\item{verbose}{Toggle warnings display.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
output
}
\description{
Analyze stanreg objects.
}
\examples{
\dontrun{
library(psycho)
require(rstanarm)
fit <- rstanarm::stan_glm(vs ~ mpg * cyl, data=mtcars)

results <- analyze(fit)
summary(results)

data <- normalize(attitude)
fit <- rstanarm::stan_lm(rating ~ advance + privileges + learning + raises,
                         data=data, prior=R2(1))

results <- analyze(fit)
summary(results)
plot(results)
print(results)
}

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
