## ----setup, include = FALSE-----------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(psychmeta)
options(width = 160)

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::kable(data_r_meas_multi[1:10,])

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
coding_sheet <- data_r_meas_multi

head(coding_sheet)

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
ma_res <- ma_r(rxyi = rxyi, 
               n = n, 
               construct_x = x_name,
               construct_y = y_name,
               sample_id = sample_id, 
               moderators = moderator,
               data = coding_sheet
               )

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
ma_res

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
summary(ma_res)

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
names(get_metatab(ma_res))

get_metatab(ma_res)$var_r

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
dplyr::as_tibble(get_metatab(ma_res))

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
as.data.frame(get_metatab(ma_res))

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
anova(ma_res)

## ---- eval=FALSE----------------------------------------------------------------------------------------------------------------------------------------------
#  metabulate(ma_res, file = "meta-analysis_results.docx", output_format = "word")

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
ma_res <- plot_funnel(ma_res)
ma_res <- plot_forest(ma_res)

## ---- fig.show='hold'-----------------------------------------------------------------------------------------------------------------------------------------
get_plots(ma_res)[["forest"]][[2]]
get_plots(ma_res)[["funnel"]][[2]]

## ---- fig.show='hold'-----------------------------------------------------------------------------------------------------------------------------------------
get_plots(ma_res)[["forest"]][[1]][["moderated"]][["barebones"]]
get_plots(ma_res)[["forest"]][[1]][["unmoderated"]][["barebones"]]

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
ma_res <- heterogeneity(ma_res)
get_heterogeneity(ma_res)[[1]][["barebones"]]

## ---- fig.show='hold'-----------------------------------------------------------------------------------------------------------------------------------------
ma_res <- sensitivity(ma_res)
get_cumulative(ma_res)[[1]][["barebones"]]
get_cumulative(ma_res)[[1]][["barebones"]][["plots"]]

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
get_bootstrap(ma_res)[[1]][["barebones"]]

