% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma_r_ic.R
\name{.estimate_attenuation}
\alias{.estimate_attenuation}
\title{Estimate the compound attenuation factors (i.e., "A") for correlations}
\usage{
.estimate_attenuation(r_observed, r_corrected)
}
\arguments{
\item{r_observed}{Vector of observed correlations.}

\item{r_corrected}{Vector of corrected correlations.}
}
\value{
A vector of compound attenuation factors.
}
\description{
For use with all artifact corrections except the Case V correction.
}
\examples{
\dontrun{
.estimate_attenuation(r_observed = .3, r_corrected = .5)
}
}
\references{
Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Thousand Oaks, CA: Sage. \url{https://doi.org/10/b6mg}. p. 144.
}
\keyword{internal}
