% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composites.R
\name{composite_d_scalar}
\alias{composite_d_scalar}
\title{Scalar formula to estimate the standardized mean difference associated with a composite variable}
\usage{
composite_d_scalar(mean_d, mean_intercor, k_vars, p = 0.5,
  partial_intercor = FALSE)
}
\arguments{
\item{mean_d}{The mean standardized mean differences associated with variables in the composite to be formed.}

\item{mean_intercor}{The mean correlation among the variables in the composite.}

\item{k_vars}{The number of variables in the composite.}

\item{p}{The proportion of cases in one of the two groups used the compute the standardized mean differences.}

\item{partial_intercor}{Logical scalar determining whether the \code{intercor} represents the partial (i.e., within-group) correlation among variables (\code{TRUE}) or the overall correlation between variables (\code{FALSE}).}
}
\value{
The estimated standardized mean difference associated with the composite variable.
}
\description{
This function estimates the \emph{d} value of a composite of X variables, given the mean \emph{d} value of the individual X values and the mean correlation among those variables.
}
\details{
There are two different methods available for computing such a composite, one that uses the partial intercorrelation among the X variables (i.e., the average within-group correlation)
and one that uses the overall correlation among the X variables (i.e., the total or mixture correlation across groups).


If a partial correlation is provided for the interrelationships among variables, the following formula is used to estimate the composite \emph{d} value:

\deqn{d_{X}=\frac{\bar{d}_{x_{i}}k}{\sqrt{\bar{\rho}_{x_{i}x_{j}}k^{2}+\left(1-\bar{\rho}_{x_{i}x_{j}}\right)k}}}{d_composite = (mean_d * k_vars) / sqrt(mean_intercor * k_vars^2 + (1 - mean_intercor) * k_vars)}

where \eqn{d_{X}}{d_composite} is the composite d value, \eqn{\bar{d}_{x_{i}}}{mean_d} is the mean \emph{d} value, \eqn{\bar{\rho}_{x_{i}x_{j}}}{mean_intercor} is the mean intercorrelation among the variables in the composite, and \emph{k} is the number of variables in the composite.
Otherwise, the composite \emph{d} value is computed by converting the mean \emph{d} value to a correlation, computing the composite correlation (see \code{\link{composite_r_scalar}} for formula), and transforming that composite back into the \emph{d} metric.
}
\examples{
composite_d_scalar(mean_d = 1, mean_intercor = .7, k_vars = 2, p = .5)
}
\references{
Rosenthal, R., & Rubin, D. B. (1986). Meta-analytic procedures for combining studies with multiple effect sizes.
\emph{Psychological Bulletin, 99}(3), 400–406.
}
