% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TE,CV,SEM.R
\name{CV}
\alias{CV}
\title{Coefficient of Variation (CV), or typical percentage error (as in Hopkins (2000)), for a set of athlete measurements}
\usage{
CV(subject, trial, ...)
}
\arguments{
\item{subject}{The vector of athletes who recorded the results for each metric (can be a numeric or factor variable)}

\item{trial}{The vector that represents which trial each measurement came from}

\item{...}{Numeric vectors that represent the metrics for which the CV should be computed. These vectors hold the scores that
each athlete recorded for each respective metric (at least one metric must be passed to the function).}
}
\value{
A data frame, with the name of each metric situated above its calculated CV
}
\description{
Computes the CV for each vector of measurements that is passed to the function, for the subject and trial vectors
}
\examples{
subject <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)
trial <- c(1, 2, 3, 1, 2, 3, 1, 2, 3)
metric_1 <- c(250, 258, 252, 279, 270, 277, 218, 213, 218)
metric_2 <- c(10, 7, 10, 14, 18, 17, 11, 7, 8)
metric_3 <- c(1214, 1276, 1289, 1037, 1010, 1069, 1481, 1465, 1443)
CV(subject, trial, metric_1, metric_2, metric_3)

}
\references{
Hopkins, W. G. (2000). Measures of Reliability in Sports Medicine and Science. Sports Medicine, 30(5), 375-381.
}
