% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltablesurv.R
\name{vlookup}
\alias{vlookup}
\title{VLOOKUP function}
\usage{
vlookup(indexval, indexvec, valvec, method = "geom")
}
\arguments{
\item{indexval}{The index value to be looked-up (may be a vector of multiple values)}

\item{indexvec}{The vector of indices to look-up within}

\item{valvec}{The vector of values corresponding to the vector of indices}

\item{method}{Method may be \code{floor}, \code{ceiling}, \code{arith} or \code{geom} (default).}
}
\value{
Numeric value or vector, depending on the lookup/interpolation method chosen:
\itemize{
\item \code{floor}: Floor (minimum) value, where interpolation is required between measured values
\item \code{ceiling}: Ceiling (maximum) value, where interpolation is required between measured values
\item \code{arith}: Arithmetic mean, where interpolation is required between measured values
\item \code{geom}: Geometric mean, where interpolation is required between measured values
}
}
\description{
Function to lookup values according to an index. Aims to behave similarly to VLOOKUP in Microsoft Excel, however several lookups can be made at once (\code{indexval} can be a vector) and interpolation is available where lookups are inexact (choice of 4 methods).
}
\examples{
# Suppose we have survival probabilities at times 0 to 20
times <- 0:20
survival <- 1-times*0.04
# We would like to look-up the survival probability at time 7
vlookup(7, times, survival)
# In this case, the floor, ceiling, arith and geom values are identical
# because survival time 7 is known, and no interpolation is necessary
vlookup(c(7, 7.5), times, survival)
# The second row of the returned tibble reveal different estimates of the survival at time 7.5.
# The values vary according to the interpolation method between
# observed survival values at times 7 and 8.
}
\seealso{
\link[HMDHFDplus:readHMDweb]{HMDHFDplus::readHMDweb} can be used to obtain lifetables from the Human Mortality Database
}
