% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probgraphs.R
\name{graph_survs}
\alias{graph_survs}
\title{Graph the observed and fitted state membership probabilities}
\usage{
graph_survs(ptdata, dpam, cuttime = 0)
}
\arguments{
\item{ptdata}{Dataset of patient level data. Must be a tibble with columns named:
\itemize{
\item ptid: patient identifier
\item pfs.durn: duration of PFS from baseline
\item pfs.flag: event flag for PFS (=1 if progression or death occurred, 0 for censoring)
\item os.durn: duration of OS from baseline
\item os.flag: event flag for OS (=1 if death occurred, 0 for censoring)
\item ttp.durn: duration of TTP from baseline (usually should be equal to pfs.durn)
\item ttp.flag: event flag for TTP (=1 if progression occurred, 0 for censoring).
}

Survival data for all other endpoints (time to progression, pre-progression death, post-progression survival) are derived from PFS and OS.}

\item{dpam}{List of survival regressions for each endpoint:
\itemize{
\item pre-progression death (PPD)
\item time to progression (TTP)
\item progression-free survival (PFS)
\item overall survival (OS)
\item post-progression survival clock forward (PPS-CF) and
\item post-progression survival clock reset (PPS-CR).
}}

\item{cuttime}{is the cut-off time for a two-piece model (default 0, indicating a one-piece model)}
}
\value{
List of two items as follows.
\code{data} is a tibble containing data derived and used in the derivation of the graphics.
\code{graph} is a list of four graphics as follows:
\itemize{
\item \code{pf}: Membership probability in PF (progression-free) state versus time since baseline, by method
\item \code{pd}: Membership probability in PD (progressive disease) state versus time since baseline, by method
\item \code{os}: Probability alive versus time since baseline, by method
\item \code{pps}: Probability alive versus time since progression, by method
}
}
\description{
Graph the observed and fitted state membership probabilities for PF, PD, OS and PPS.
}
\examples{
\donttest{
bosonc <- create_dummydata("flexbosms")
fits <- fit_ends_mods_par(bosonc)
# Pick out best distribution according to min AIC
params <- list(
  ppd = find_bestfit(fits$ppd, "aic")$fit,
  ttp = find_bestfit(fits$ttp, "aic")$fit,
  pfs = find_bestfit(fits$pfs, "aic")$fit,
  os = find_bestfit(fits$os, "aic")$fit,
  pps_cf = find_bestfit(fits$pps_cf, "aic")$fit,
  pps_cr = find_bestfit(fits$pps_cr, "aic")$fit
)
# Create graphics
gs <- graph_survs(ptdata=bosonc, dpam=params)
gs$graph$pd
}
}
