% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite.R
\name{prepareComposite}
\alias{prepareComposite}
\title{Prepare distance scores on data in preparation for composite scoring}
\usage{
prepareComposite(
  object,
  winsorize = 0,
  values,
  better = TRUE,
  covmat,
  standardize = TRUE,
  use.prethreshold = FALSE
)
}
\arguments{
\item{object}{An object of class \sQuote{CompositeData}.}

\item{winsorize}{Whether to winsorize the data or not.  Defaults to \code{FALSE}.
If not \code{FALSE}, the percentile to winsorize at.  For example, .01 would be
the .01 and the 1 - .01 percentiles.}

\item{values}{The values to use for winsorization.  Optional.  If specified, preempts
the percentiles given by winsorize.}

\item{better}{Logical indicating whether \dQuote{better} values than the threshold
  are allowed. Defaults to \code{TRUE}.
#' @param object An DistanceScores class object}

\item{covmat}{The covariance matrix to use.  If missing,
austomatically calculated from the data.}

\item{standardize}{A logical value whether to standardize the data or not.
Defaults to \code{TRUE}.}

\item{use.prethreshold}{A logical value whether to calculate covariance matrix
based on the data after winsorizing, but before applying the threshold.
Defaults to \code{FALSE}, so that covariances are calculated after thresholds
(if any) are applied.}
}
\value{
An S4 object of class \dQuote{CompositeReady}.
}
\description{
Prepare distance scores on data in preparation for composite scoring
}
\examples{
# this example creates distances for the built in mtcars data
# see ?mtcars for more details
# The distances are calculated from the "best" in the dataset
# First we create an appropriate CompositeData class object
# higher mpg & hp are better and lower wt & qsec are better
d <- CompositeData(mtcars[, c("mpg", "hp", "wt", "qsec")],
  thresholds = list(one = with(mtcars, c(
    mpg = max(mpg),
    hp = max(hp),
    wt = min(wt),
    qsec = min(qsec)))
  ),
  higherisbetter = c(TRUE, TRUE, FALSE, FALSE),
  rawtrans = list(
    mpg = function(x) x,
    hp = function(x) x,
    wt = function(x) x,
    qsec = sqrt))


# create the distance scores
dres <- prepareComposite(d)

# see a density plot of the distance scores
dres@distanceDensity
# regular summary of distance scores
summary(dres@distances)

# examine covariance matrix
round(dres@covmat,2)
# cleanup
rm(d, dres)

}
\concept{prepare}
