/*************************************************************************
 ** truncated Normal sampling
 **
 ** simon jackman, dept of political science, stanford university
 ** feb 2000
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <Rmath.h>
#include "util.h"

static double zero = 0.0;
static double arg = 0.5;
static double iarg = 0.5;
static double pupper = 0.5;
static double one = 1.0;


double dtnorm(double *mu, double *sd, double *y)
{
  double f, z, q, norm;
  int loop=1; 

  if (*y==0.0){
    z = *mu/(*sd);
    if(z<1.6){
      /* try rejection sampling */
      while(loop){
	norm = rnorm(*mu, *sd);
	if (norm < 0.0){
	  return(norm);
	}
      }
    }
    else{
      /* otherwise use inverse-uniform method, z is always positive */
      /* work with natural logarithms to avoid underflows */
      f = -exp_rand();

      pupper = pnorm(z,zero,one,0,1);
      arg = f + pupper;
      iarg = qnorm(arg,zero,one,1,1);

      q = *mu + (*sd)*iarg;
      return(q);
    }
  }
  else{  /* Y=1 */
    /* try rejection sampling */
    z = *mu/(*sd);
    if(z>-1.6){
      while(loop){
	norm = rnorm(*mu, *sd);
	if (norm > 0.0){
	  return(norm);
	}
      }
    }
    else{
      /* otherwise use inverse-uniform method, n.b., z is always neg */
      /* work with natural logarithms to avoid underflows */
      f = -exp_rand();

      pupper = pnorm(z,zero,one,1,1);
      arg = f + pupper;
      iarg = qnorm(arg,zero,one,0,1);

      q = *mu + (*sd)*iarg;
      return(q);
    }
  }
}
