% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/borrowing_none.R
\name{borrowing_none}
\alias{borrowing_none}
\title{No borrowing}
\usage{
borrowing_none(ext_flag_col)
}
\arguments{
\item{ext_flag_col}{character. Name of the external flag column in the matrix.}
}
\value{
Object of class \code{\link[=BorrowingNone-class]{BorrowingNone}}.
}
\description{
No borrowing
}
\details{
\subsection{Method}{

This method evaluates only the internal comparison,
ignoring historical controls. Note that this method will filter the
model matrix based on values in \code{ext_flag_col}.
}

\subsection{External Control}{

The \code{ext_flag_col} argument refers to the column in the data matrix that
contains the flag indicating a patient is from the external control cohort.
}
}
\examples{
db <- borrowing_none(
  ext_flag_col = "ext"
)
}
\seealso{
Other borrowing: 
\code{\link{borrowing_full}()}
}
\concept{borrowing}
