% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data_baseline.R
\name{generate,BaselineObject-method}
\alias{generate,BaselineObject-method}
\title{Generate Data for a \code{BaselineObject}}
\usage{
\S4method{generate}{BaselineObject}(x, ...)
}
\arguments{
\item{x}{a \code{BaselineObject} object created by \link{create_baseline_object}}

\item{...}{additional parameters are ignored}
}
\value{
A \link[=BaselineDataFrame-class]{BaselineDataFrame} object
}
\description{
Generate Data for a \code{BaselineObject}
}
\examples{
bl_biomarkers <- create_baseline_object(
  n_trt_int = 100,
  n_ctrl_int = 50,
  n_ctrl_ext = 100,
  covariates = baseline_covariates(
    c("b1", "b2", "b3"),
    means_int = c(0, 0, 0),
    covariance_int = covariance_matrix(c(1, 1, 1), c(.8, .3, .8))
  ),
  transformations = list(
    exp_b1 = function(data) exp(data$b1),
    b2 = binary_cutoff("b2", int_cutoff = 0.7, ext_cutoff = 0.5)
  )
)
generate(bl_biomarkers)
}
