% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disk.R
\name{ps_disk_partitions}
\alias{ps_disk_partitions}
\title{List all mounted partitions}
\usage{
ps_disk_partitions(all = FALSE)
}
\arguments{
\item{all}{Whether to list virtual devices as well. If \code{FALSE}, on
Linux it will still list \code{overlay} and \code{grpcfuse} file systems, to
provide some useful information in Docker containers.}
}
\value{
A data frame with columns \code{device}, \code{mountpoint},
\code{fstype} and \code{options}.
}
\description{
The output is similar the Unix \code{mount} and \code{df} commands.
}
\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ps_disk_partitions(all = TRUE)
ps_disk_partitions()
\dontshow{\}) # examplesIf}
}
\seealso{
Other disk functions: 
\code{\link{ps_disk_usage}()}
}
\concept{disk functions}
