% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_status}
\alias{ps_status}
\title{Current process status}
\usage{
ps_status(p)
}
\arguments{
\item{p}{Process handle.}
}
\value{
Character scalar.
}
\description{
One of the following:
\itemize{
\item \code{"idle"}: Process being created by fork, macOS only.
\item \code{"running"}: Currently runnable on macOS and Windows. Actually
running on Linux.
\item \code{"sleeping"} Sleeping on a wait or poll.
\item \code{"disk_sleep"} Uninterruptible sleep, waiting for an I/O operation
(Linux only).
\item \code{"stopped"} Stopped, either by a job control signal or because it
is being traced.
\item \code{"tracing_stop"} Stopped for tracing (Linux only).
\item \code{"zombie"} Zombie. Finished, but parent has not read out the exit
status yet.
\item \code{"dead"} Should never be seen (Linux).
\item \code{"wake_kill"} Received fatal signal (Linux only).
\item \code{"waking"} Paging (Linux only, not valid since the 2.6.xx kernel).
}
}
\details{
Works for zombie processes.
}
\seealso{
Other process handle functions: \code{\link{ps_children}},
  \code{\link{ps_cmdline}}, \code{\link{ps_cpu_times}},
  \code{\link{ps_create_time}}, \code{\link{ps_cwd}},
  \code{\link{ps_environ}}, \code{\link{ps_exe}},
  \code{\link{ps_handle}}, \code{\link{ps_is_running}},
  \code{\link{ps_kill}}, \code{\link{ps_memory_info}},
  \code{\link{ps_name}}, \code{\link{ps_num_threads}},
  \code{\link{ps_pid}}, \code{\link{ps_ppid}},
  \code{\link{ps_resume}}, \code{\link{ps_send_signal}},
  \code{\link{ps_suspend}}, \code{\link{ps_terminal}},
  \code{\link{ps_terminate}}, \code{\link{ps_uids}},
  \code{\link{ps_username}}
}
\section{Examples}{
\Sexpr[stage=install,strip.white=FALSE,results=rd]{ps:::decorate_examples('
p <- ps_handle()
p
ps_status(p)
')}
}
