% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolbox.R
\name{read.compositional}
\alias{read.compositional}
\title{Read a .csv file with categorical data}
\usage{
read.compositional(fname, method = NULL, colmap = "rainbow")
}
\arguments{
\item{fname}{a string with the path to the .csv file}

\item{method}{either "bray" (for the Bray-Curtis distance) or
"aitchison" (for Aitchison's central logratio distance). If
omitted, the function defaults to 'aitchison', unless there are
zeros present in the data.}

\item{colmap}{an optional string with the name of one of R's
built-in colour palettes (e.g., heat.colors, terrain.colors,
topo.colors, cm.colors), which are to be used for plotting the data.}
}
\value{
an object of class \code{compositional}, i.e. a list with the
following items:

\code{x}: a data frame with the samples as rows and the categories as columns

\code{method}: either "aitchison" (for Aitchison's centred logratio
distance) or "bray" (for the Bray-Curtis distance)
}
\description{
Reads a data table containing categorical data (e.g. petrographic,
heavy mineral or geochemical data)
}
\examples{
fname <- system.file("Major.csv",package="provenance")
Major <- read.compositional(fname)
plot(PCA(Major))
}
