/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.file_chooser;

import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import com.qarks.util.ui.swing.file_chooser.DefaultFileView;
import com.qarks.util.ui.swing.file_chooser.FileSystemParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;

public class DirectoryChooser
extends JPanel {
    private FileSystemParser mFileSystemParser = null;
    private int mResult;
    public static final int OK = 1;
    public static final int CANCEL = 2;

    public DirectoryChooser() {
        DefaultFileView defaultFileView = new DefaultFileView();
        this.mFileSystemParser = new FileSystemParser(FileSystemView.getFileSystemView(), defaultFileView, null);
        this.setLayout(new GridLayout(1, 1));
        this.add(new JScrollPane(this.mFileSystemParser));
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mFileSystemParser.setEnabled(bl);
        this.mFileSystemParser.setEditable(bl);
    }

    public boolean isCancelled() {
        return this.mResult == 2;
    }

    public String getSelectedDirectory() {
        return this.mFileSystemParser.getCurrentDirectory();
    }

    public void setCurrentDirectory(String string) {
        this.mFileSystemParser.setCurrentDirectory(string);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.mFileSystemParser.addTreeSelectionListener(treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.mFileSystemParser.removeTreeSelectionListener(treeSelectionListener);
    }

    public int getResult() {
        return this.mResult;
    }

    public static DirectoryChooser openDialog(Window window, String string, String string2) {
        final JDialog jDialog = new JDialog(window, Dialog.ModalityType.APPLICATION_MODAL);
        jDialog.getContentPane().setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JButton jButton = new JButton(ResourceManager.getString((Object)ResourceKey.OK));
        JButton jButton2 = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        final DirectoryChooser directoryChooser = new DirectoryChooser();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                directoryChooser.mResult = 1;
                jDialog.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                directoryChooser.mResult = 2;
                jDialog.dispose();
            }
        });
        jPanel.add((Component)jPanel2, "South");
        directoryChooser.setCurrentDirectory(string);
        jPanel.add((Component)directoryChooser, "Center");
        jDialog.setSize(500, 500);
        jDialog.setTitle(string2);
        jDialog.getContentPane().add(jPanel);
        if (window.isShowing()) {
            DialogUtilities.centerWindow(jDialog, window);
        } else {
            DialogUtilities.centerOnScreen(jDialog);
        }
        return directoryChooser;
    }
}

