% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomize.R
\name{assignPlatePosition}
\alias{assignPlatePosition}
\title{Assign an instrument queue configuration to a plate}
\usage{
assignPlatePosition(
  S,
  x = as.character(1:8),
  y = c("A", "B", "C", "D", "E", "F"),
  plate = 1:4,
  volume = 1,
  reserve = 46:48
)
}
\arguments{
\item{S}{input data frame}

\item{x}{a vector of possible x-coordinates of the plate}

\item{y}{a vector of possible y-coordinates of the plate}

\item{plate}{a vector of plates}

\item{volume}{injection volume}

\item{reserve}{block plate positions}
}
\value{
a \code{data.frame}
}
\description{
The function implements a space-filling curve mapping 1D to 2D.
This function aims to assign a sequence of samples to an instrument plate,
e.g., 48 well plate 85.4x127.5mm.
}
\examples{
iris[c(1:15, 51:65, 101:115), ] |>
  blockRandom(x = "Species", check=FALSE) |>
  assignPlatePosition()
}
