% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nircal.R
\name{read_nircal}
\alias{read_nircal}
\title{Import BUCHI NIRCal files}
\usage{
read_nircal(file, responsevar = TRUE, spectra = TRUE, 
            metadata = TRUE, progress = TRUE, verbose = TRUE)
}
\arguments{
\item{file}{the name of the NIRCal (.nir) file which the data are to be read from.}

\item{responsevar}{a logical indicating if the data of the response variables must be returned (default is \code{TRUE}).}

\item{spectra}{a logical indicating if the spectral data must be returned  (default is \code{TRUE}).}

\item{metadata}{a logical indicating if the metadada must be returned  (default is \code{TRUE}).}

\item{progress}{a logical indicating if a progress bar must be printed (default is \code{TRUE}).}

\item{verbose}{a logical indicating if the number of spectra and response variables (an also the ID's of the spectra without gain and/or temperature information) must be printed (default is \code{TRUE}).}
}
\value{
a \code{data.frame} containing the metadata, response variables (if \code{responsevar = TRUE}) and spectra (if \code{spectra = TRUE}, embedded in the \code{data.frame} as a \code{matrix} named \code{...$spc}).
}
\description{
This function imports .nir files generated by BUCHI NIRCal software.
}
\details{
The extension of the BUCHI NIRCal files is .nir. These files are used to store spectra generated by BUCHI N-500 and BUCHI NIRMaster FT-NIR sensors. 
See: \url{https://www.buchi.com/gb-en/products/nirsolutions/nircal}
}
\author{
Leonardo Ramirez-Lopez
}
