% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teeMod.R
\name{.align_and_extend_estfuns}
\alias{.align_and_extend_estfuns}
\title{(Internal) Align the dimensions and rows of direct adjustment and
covariance adjustment model estimating equations matrices}
\usage{
.align_and_extend_estfuns(x, ctrl_means_ef_mat = NULL, by = NULL, ...)
}
\arguments{
\item{x}{a fitted \code{teeMod} model}

\item{ctrl_means_ef_mat}{optional, a matrix of estimating equations corresponding
to the estimates of the marginal (and possibly conditional) means of the outcome
and \code{offset} in the control condition. These are aligned and extended
in the same way as the matrix of estimating equations for \code{x} and
\code{cbind}ed to them}

\item{by}{optional, a character vector indicating columns that uniquely identify
rows in the dataframe used for fitting \code{x} and the dataframe passed to the
\code{data} argument of the covariance adjustment model fit. The default is
\code{NULL}, in which case the unit of assignment columns specified in the
\code{StudySpecification} slot of \code{x} are used.}

\item{...}{mostly arguments passed to methods, but the special case is the argument
\code{loco_residuals}, which indicates the offsets in the residuals of \code{x}
should be replaced by versions that use leave-one-cluster-out estimates of
the covariance model}
}
\value{
A list of two matrices, one being the aligned contributions to the
estimating equations for the direct adjustment model, and the other being
the aligned contributions to the covariance adjustment model.
}
\description{
(Internal) Align the dimensions and rows of direct adjustment and
covariance adjustment model estimating equations matrices
}
\details{
\code{.align_and_extend_estfuns()} first extracts the matrices of
contributions to the empirical estimating equations for the direct
adjustment and covariance adjustment models; then, it pads the matrices
with zeros to account for units of observation that appear in one
model-fitting sample but not the other; finally it orders the matrices so
units of observation (or if unit of observation-level ordering is
impossible, units of assignment) are aligned.
}
\keyword{internal}
