% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_data}
\alias{normalize_data}
\title{Normalize intensity data}
\usage{
normalize_data(df, method = "quantile")
}
\arguments{
\item{df}{An \code{imp_df} object with missing values imputed using
\code{impute_na} or a \code{raw_df} object containing missing values.}

\item{method}{Name of the normalization method to use. Choices are
\code{"none", "scale", "quantile" or "cyclicloess."}
Default is \code{"quantile."}}
}
\value{
A \code{norm_df} object, which is a data frame of
normalized protein intensities.
}
\description{
This function normalizes data using a user-specified
normalization method.
}
\details{
\itemize{\item\code{normalize_data} is a wrapper function around
the \code{\link[limma]{normalizeBetweenArrays}} function from the
\code{limma} package. \item This function normalizes
intensity values to achieve consistency among samples.
\item It assumes that the intensities in the
data frame have been log-transformed, therefore, it is important to make sure
that \code{create_df} was run with \code{log_tr = TRUE}(default) when
creating the \code{raw_df} object.}
}
\examples{
## Generate a raw_df object with default settings. No technical replicates.
raw_df <- create_df(
  prot_groups = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/pg1.txt",
  exp_design = "https://raw.githubusercontent.com/caranathunge/promor_example_data/main/ed1.txt"
)

## Impute missing values in the data frame using the default minProb
## method prioir to normalization.
imp_df <- impute_na(raw_df)

## Normalize the imp_df object using the default quantile method
norm_df1 <- normalize_data(imp_df)

## Use the cyclicloess method
norm_df2 <- normalize_data(imp_df, method = "cyclicloess")

## Normalize data in the raw_df object prior to imputation.
norm_df3 <- normalize_data(raw_df)

}
\seealso{
\itemize{\item \code{create_df}
\item \code{impute_na}
\item See \code{\link[limma]{normalizeBetweenArrays}} in the R package
\code{limma} for more information on the different normalization methods
available.}
}
\author{
Chathurani Ranathunge
}
