% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/critical_path.R
\name{simulation}
\alias{simulation}
\title{Runs a simulation on project end time when certain tasks have uncertain durations}
\usage{
simulation(df, iter = 100)
}
\arguments{
\item{df}{A data frame of tasks with columns ID, name, duration,
id's of predecessrs (as a comma separated string), type of distrubtion
for the uncertain task (currently, "triangle", "pert", "uniform", "normal"
and "log_normal" are supported), and additional hyperparameters for the
uncertain task, described below. For "triangle" and "pert", the next
three columns should be minimum end time, maximum end time, and most
likely end time (all in days) for the uncertain tasks in that order.
For "uniform", the next two columns should be minimum and maximum end time
(in days) for uncertain tasks. For "normal" and "log_normal",
the next two columns should be mean and standard deviation (in days)
of end time. Tasks with a null value for the distribution (fifth) column
will not be treated as uncertain tasks. Note that names of columns do not
matter, only order. Type 'taskdatauncertain1' into the console for an
example of valid data.}

\item{iter}{Default: 1000. The number of times the simulation should run.}
}
\value{
A list of results.

\itemize{
\item \strong{durations} A vector of doubles (of the same size as 'iter')
that contains the total project duration for each itertation of the
simulation.
\item \strong{histogram} A histogram of 'durations'
}
}
\description{
Runs a simulation on project end time when certain tasks have uncertain durations
}
\examples{
# Example using built in data
simulation(taskdatauncertain1, 10000)

}
