% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit.R, R/new.R
\name{edit_project}
\alias{edit_project}
\alias{edit_author}
\alias{edit_affiliation}
\alias{delete_project}
\alias{delete_author}
\alias{delete_affiliation}
\alias{new_edit_delete}
\alias{new_project}
\alias{new_author}
\alias{new_affiliation}
\title{Create, edit or delete projects, authors and affiliations}
\usage{
edit_project(project, title = NA, short_title = NA, authors,
  current_owner = NA, status = NA, deadline_type = NA,
  deadline = NA, stage = c("1: design", "2: data collection",
  "3: analysis", "4: manuscript", "5: under review", "6: accepted"),
  corresp_auth = NA, creator = NA, reprint_header = TRUE,
  archived = FALSE)

edit_author(author, given_names = NA, last_name = NA, affiliations,
  title = NA, degree = NA, email = NA, phone = NA)

edit_affiliation(affiliation, department_name = NA,
  institution_name = NA, address = NA)

delete_project(project, archived = FALSE)

delete_author(author)

delete_affiliation(affiliation)

new_project(title = NA, short_title = NA, authors = NULL,
  current_owner = NA, status = "just created", deadline_type = NA,
  deadline = NA, stage = c("1: design", "2: data collection",
  "3: analysis", "4: manuscript", "5: under review", "6: accepted"),
  path = projects_folder(), make_directories = FALSE,
  corresp_auth = NA, creator = Sys.info()["user"], id = NA,
  protocol = c("01_protocol.Rmd", "STROBE_protocol.Rmd",
  "CONSORT_protocol.Rmd"), datawork = "02_datawork.Rmd",
  analysis = "03_analysis.Rmd", report = "04_report.Rmd",
  css = "style.css", Rproj = "pXXXX.Rproj", use_bib = FALSE)

new_author(given_names = NA, last_name = NA, title = NA,
  affiliations, degree = NA, email = NA, phone = NA, id = NA)

new_affiliation(department_name = NA, institution_name = NA,
  address = NA, id = NA)
}
\arguments{
\item{project, author, affiliation}{The \code{id} or unambiguous names of a
project/author/affiliation to edit or delete.}

\item{title}{For the \code{\*_project()} functions, the title of the project;
  for \code{new_project()} only, the user input is coerced to title case
  using \code{tools::toTitleCase()}.

  For the \code{\*_author()} functions, the job title of the author.}

\item{short_title}{A nickname for the project. Can be used in other
\code{projects} package functions whenever needing to specify a project.}

\item{authors, affiliations}{For \code{new_project()}/\code{new_author()}, a
  vector of \code{id}s or unambiguous \code{given_names}/\code{last_name} or
  \code{department_name}/\code{institution_name} of
  \code{\link{authors}}/\code{\link{affiliations}}. Order will be preserved.

  For \code{edit_project()}/\code{edit_author()}, a formula specifying
  \code{\link{authors}}/\code{\link{affiliations}} to add or remove from the
  project/author. Formulas must have no left-hand side (i.e., begin with
  \code{~}) and use \code{+} to add authors and \code{-} to remove authors.
  Authors may be specified by \code{id} or name.

  Each element must match a row in the \code{\link{authors}} tibble.}

\item{status}{A free text field, intended to communicate the most current
  condition the project is in.

  For \code{new_project()}, default is \code{"just created"}.}

\item{deadline_type}{A free text field, intended to communicate the meaning
of the next field, \code{deadline}.}

\item{deadline}{A \code{Date} or a character string that can be coerced to a
\code{Date}.}

\item{stage}{A factor with the levels \code{c("1: design", "2: data
collection", "3: analysis", "4: manuscript", "5: under review", "5:
accepted")}, communicating the stage the project is in.}

\item{corresp_auth, current_owner}{An \code{id} or unambiguous
  \code{last_name}/\code{given_names} of one of the authors in the
  \code{\link{authors}} table.

  If \code{corresp_auth} is specified, all of this author's contact
  information will be especially included in the project's
  \code{\link{header}}.}

\item{creator}{The author who created the project. If it is equal to
\code{Sys.info()["user"]} (the default value), it is kept as is. Otherwise
it will be validated against the \code{authors()} tibble and populated with
the matching author \code{id}.}

\item{reprint_header}{Logical, indicating whether or not to reprint the
project \code{\link{header}} after editing project information.}

\item{archived}{Logical indicating whether or not the function should
  consider archived projects when determining which project the user is
  referring to in the \code{project} argument. \code{FALSE} by default.

  See the \strong{Details} section of \code{\link{archive_project}()} for
  more information on the "archived" status of a project.}

\item{given_names, last_name, department_name, institution_name}{Each a single
character string. Can be used whenever needing to specify a specific
author/affiliation.}

\item{degree}{A character string (preferably an abbreviation) denoting the
author's academic degree(s). Will be written next to author names in the
\code{\link{header}}.}

\item{email, phone}{A character string denoting the email/phone of the author.
Email will be coerced to lowercase. When a project is given a
\code{corresp_auth}, these items will be included in the
\code{\link{header}}.}

\item{address}{A character string indicating the address of the affiliation.}

\item{path}{A character string that can be read as a file path. Can be
  either:

  1) the \emph{absolute} path of the \code{\link{projects_folder}} (default)

  2) an \emph{absolute} path pointing to a subfolder within the
  \code{\link{projects_folder}}

  3) a \emph{relative} path (leading \code{"."} optional) that will be
  appended onto the end of the \code{\link{projects_folder}}.

  In any case, the result is that the new project folder will be a
  subdirectory of the main \code{\link{projects_folder}}. See also
  \code{\link{setup_projects}()}.}

\item{make_directories}{Logical, indicating whether or not
\code{new_project()} should create subdirectories specified in the
\code{path} argument that do not already exist. Ignored if \code{path} is
left as the default or if all directories in \code{path} already exist.}

\item{id}{An integer that will become the item's permanent identification
  number. Must be in the range 1-9999 or left blank. If left blank, the
  lowest available integer in the aforementioned range will be selected.

  For \code{new_project}, this number will also determine the project
  folder's and \emph{.Rproj} file's names, which are of the form
  "p\emph{XXXX}". If the \code{id} number is not four digits long, it will be
  padded on the left side with 0s.}

\item{protocol, datawork, analysis, report, css, Rproj}{A character string
  matching the name of a corresponding template file in the \emph{.templates}
  subdirectory of the main \code{\link{projects_folder}}. Default templates
  are placed there when \code{\link{setup_projects}()} is run, and the user
  can edit these if desired.

  Multiple default \code{protocol} templates are available.
  \emph{01_protocol.Rmd}, which by default is the same as
  \emph{STROBE_protocol.Rmd}, will be selected if \code{protocol} is
  unspecified. Users can edit these default templates.

  If using a custom template, make sure to match the case and file extension
  exactly.}

\item{use_bib}{Logical. If \code{TRUE}, a blank \emph{.bib} file will be
written into the \strong{progs} subdirectory of the newly created project
folder. Its name will be of the form \emph{pXXXX.bib}, and the YAML header
of \emph{progs/01_protocol.Rmd} and \emph{progs/04_report.Rmd} will include
the line \code{bibliography: pXXXX.bib}.}
}
\description{
These functions create, edit, or delete rows in the \code{\link{projects}()},
\code{\link{authors}()}, and \code{\link{affiliations}()} tibbles, which are
stored in the \emph{.metadata} subdirectory of the main
\code{\link{projects_folder}}.
}
\details{
\code{new_project()} creates a new R project folder that is automatically
filled with a \emph{.Rproj} file, helpful subdirectories, and \emph{.Rmd}
files to get your project workflow started; \code{delete_project()} deletes
them. The \code{edit_\*()} functions and the other \code{new_\*()} and
\code{delete_\*()} functions only create or edit rows in the \emph{.metadata}
tibbles.

Newly created project folders (and the \emph{.Rproj} files they contain) both
have names of the form "p\emph{XXXX}", where "\emph{XXXX}" denotes the
project \code{id} number. The folder will be an immediate subdirectory of the
main \code{\link{projects_folder}} (see also \code{\link{setup_projects}()})
unless the argument \code{path} specifies a deeper subdirectory. The user may
enter various metadata about the project that is stored and may be called
forth using the \code{\link{projects}()} function. Some of this metadata will
automatically be added to the \code{\link{header}} atop the automatically
created \emph{.Rmd} files called \emph{progs/01_protocol.Rmd} and
\emph{progs/04_report.Rmd}.
}
\examples{
# SETUP
old_path <- Sys.getenv("PROJECTS_FOLDER_PATH")
setup_projects(path = tempdir(), .Renviron_path = fs::path_temp(".Renviron"))
############################################################################

# Creating affiliations
new_affiliation(department_name = "Math Dept.",
                institution_name = "Springfield College",
                address = "123 College St, Springfield, AB")
new_affiliation(department_name = "Art Department",
                institution_name = "Springfield College",
                address = "321 University Boulevard, Springfield, AB",
                id = 42)

# Editing an affiliation
edit_affiliation("Math Dept", department_name = "Mathematics Department")

# Creating authors
new_author(given_names = "Rosetta", last_name = "Stone",
           affiliations = c(42, "Math"), degree = "PhD",
           email = "slab@rock.net", phone = "867-555-5309", id = 8888)
new_author(given_names = "Spiro", last_name = "Agnew", degree = "LLB",
           affiliations = "Art D", id = 13)
new_author(last_name = "Plato", id = 303)

# Editing an author, showcasing the removal of a text element (last_name)
edit_author(author = 303, given_names = "Plato", last_name = NULL)

# Editing an author, showcasing the addition and removal of affiliations
edit_author("Spiro", affiliations = ~ -"Art D" + Math)

# Creating a project
new_project(title = "Understanding the Construction of the United States",
            short_title = "USA", authors = c(13, "Stone"),
            stage = 4, deadline = "2055-02-28", deadline_type = "submission",
            path = "famous_studied/philosophers/rocks",
            corresp_auth = "Stone", current_owner = "agnew",
            make_directories = TRUE, use_bib = TRUE,
            status = "waiting on IRB")

# Editing a project, showcasing the addition and removal of authors
edit_project("Understanding", short_title = "usa1",
             authors = ~ + "303" - 13 - Stone)

# Wrapped in if(interactive()) because it requires interactive console input
# and fails automated package checking and testing.
if(interactive()) {
  delete_project("usa1")
  delete_author(303)
  delete_affiliation("Math")
}

#############################################################################
# CLEANUP
Sys.setenv(PROJECTS_FOLDER_PATH = old_path)
fs::file_delete(c(fs::path_temp("projects"), fs::path_temp(".Renviron")))
}
