\name{getEvent}
\alias{getEvent}
\title{Extract a column from an event history object.}
\usage{
getEvent(object, mode = "factor", column = "event")
}
\arguments{
  \item{object}{Object of class \code{"Hist"}.}

  \item{mode}{Return mode. One of \code{"numeric"},
  \code{"character"}, or \code{"factor"}.}

  \item{column}{Name of the column to extract from the
  object.}
}
\description{
Extract a column from an event history object, as obtained
with the function \code{\link{Hist}}.
}
\details{
Since objects of class \code{"Hist"} are also matrices, all
columns are numeric or integer valued. To extract a
correctly labeled version, the attribute \code{states} of
the object is used to generate factor levels.
}
\examples{
dat= data.frame(time=1:5,event=letters[1:5])
  x=with(dat,Hist(time,event))
  ## inside integer
  unclass(x)
  ## extract event (the extra level "unknown" is for censored data)
  getEvent(x)
}
\author{
Thomas Alexander Gerds <tag@biostat.ku.dk>
}
\seealso{
\code{\link{Hist}}
}
\keyword{survival}

