% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{births}
\alias{births}
\title{Birth outcome data}
\format{
\subsection{\code{births}}{

A data frame with 50,249 rows and 20 columns:
\describe{
\item{birthtime}{Birth time during day (in minutes, range is 0 to 2399)}
\item{birthwkday}{Day of week of birth (1=Sunday, 2=Monday, ..., 7=Saturday)}
\item{age}{Mother's age (in years)}
\item{nonhsgrad}{1 if mother is not a HS graduate, 0 otherwise}
\item{hsgrad}{1 if mother is HS graduate and has no add'l education, 0 otherwise}
\item{somecoll}{1 if mother completed some college, 0 otherwise}
\item{collgrad}{1 if mother is 4-year college graduate, 0 otherwise}
\item{married}{1 if mother is married, 0 otherwise}
\item{smoke1}{1 if mother smoked during first trimester, 0 otherwise}
\item{smoke2}{1 if mother smoked during second trimester, 0 otherwise}
\item{smoke3}{1 if mother smoked during third trimester, 0 otherwise}
\item{smokepre}{1 if mother smoked before pregnancy, 0 otherwise}
\item{smoke}{1 if mother smoked during pregnancy (any trimester), 0 otherwise}
\item{prenatal1}{1 if first prenatal care during first trimester, 0 otherwise}
\item{prenatal2}{1 if first prenatal care during second trimester, 0 otherwise}
\item{prenatal3}{1 if first prenatal care during third trimester, 0 otherwise}
\item{nocare}{1 if no prenatal care visit, 0 otherwise}
\item{male}{1 if baby is a boy, 0 otherwise}
\item{bweight}{Birthweight (in grams)}
\item{bweight_lbs}{Birthweight (in pounds)}
}
}
}
\source{
\url{https://www.nber.org/research/data/vital-statistics-natality-birth-data}
}
\usage{
births
}
\description{
Data on birth outcomes in the United States for December 2021 births where
mother's age is between 25 and 35 (inclusive), limited to singleton births,
mother's first child, and having non-missing values for relevant variables
}
\keyword{datasets}
