% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_class_pred.R
\name{append_class_pred}
\alias{append_class_pred}
\title{Add a \code{class_pred} column}
\usage{
append_class_pred(
  .data,
  ...,
  levels,
  ordered = FALSE,
  min_prob = 1/length(levels),
  name = ".class_pred"
)
}
\arguments{
\item{.data}{A data frame or tibble.}

\item{...}{One or more unquoted expressions separated by commas
to capture the columns of \code{.data} containing the class
probabilities. You can treat variable names like they are
positions, so you can use expressions like \code{x:y} to select ranges
of variables or use selector functions to choose which columns.
For \code{make_class_pred}, the columns for all class probabilities
should be selected (in the same order as the \code{levels} object).
For \code{two_class_pred}, a vector of class probabilities should be
selected.}

\item{levels}{A character vector of class levels. The length should be the
same as the number of selections made through \code{...}, or length \code{2}
for \code{make_two_class_pred()}.}

\item{ordered}{A single logical to determine if the levels should be regarded
as ordered (in the order given). This results in a \code{class_pred} object
that is flagged as ordered.}

\item{min_prob}{A single numeric value. If any probabilities are less than
this value (by row), the row is marked as \emph{equivocal}.}

\item{name}{A single character value for the name of the appended
\code{class_pred} column.}
}
\value{
\code{.data} with an extra \code{class_pred} column appended onto it.
}
\description{
This function is similar to \code{\link[=make_class_pred]{make_class_pred()}}, but is useful when you have
a large number of class probability columns and want to use \code{tidyselect}
helpers. It appends the new \code{class_pred} vector as a column on the original
data frame.
}
\examples{

# The following two examples are equivalent and demonstrate
# the helper, append_class_pred()

library(dplyr)

species_probs |>
  mutate(
    .class_pred = make_class_pred(
      .pred_bobcat, .pred_coyote, .pred_gray_fox,
      levels = levels(Species),
      min_prob = .5
    )
  )

lvls <- levels(species_probs$Species)

append_class_pred(
  .data = species_probs,
  contains(".pred_"),
  levels = lvls,
  min_prob = .5
)

}
