% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-pred.R
\name{class_pred}
\alias{class_pred}
\title{Create a class prediction object}
\usage{
class_pred(x = factor(), which = integer(), equivocal = "[EQ]")
}
\arguments{
\item{x}{A factor or ordered factor.}

\item{which}{An integer vector specifying the locations of \code{x} to declare
as equivocal.}

\item{equivocal}{A single character specifying the equivocal label used
when printing.}
}
\description{
\code{class_pred()} creates a \code{class_pred} object from a factor or ordered
factor. You can optionally specify values of the factor to be set
as \emph{equivocal}.
}
\details{
Equivocal values are those that you feel unsure about, and would like to
exclude from performance calculations or other metrics.
}
\examples{

x <- factor(c("Yes", "No", "Yes", "Yes"))

# Create a class_pred object from a factor
class_pred(x)

# Say you aren't sure about that 2nd "Yes" value. You could mark it as
# equivocal.
class_pred(x, which = 3)

# Maybe you want a different equivocal label
class_pred(x, which = 3, equivocal = "eq_value")

}
