% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_names.R
\name{feature_names}
\alias{feature_names}
\alias{feature_names,ConservationProblem-method}
\alias{feature_names,ZonesRaster-method}
\alias{feature_names,ZonesCharacter-method}
\title{Feature names}
\usage{
feature_names(x)

\S4method{feature_names}{ConservationProblem}(x)

\S4method{feature_names}{ZonesRaster}(x)

\S4method{feature_names}{ZonesCharacter}(x)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} (i.e., \code{\linkS4class{ConservationProblem}}) or \code{\link[=Zones]{Zones()}}
object.}
}
\value{
\code{character} feature names.
}
\description{
Extract the names of the features in an object.
}
\examples{
# load data
data(sim_pu_raster, sim_features)

# create problem
p <- problem(sim_pu_raster, sim_features) \%>\%
     add_min_set_objective() \%>\%
     add_relative_targets(0.2) \%>\%
     add_binary_decisions()

# print feature names
print(feature_names(p))
}
