% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_ferrier_importance.R
\name{eval_ferrier_importance}
\alias{eval_ferrier_importance}
\alias{eval_ferrier_importance,ConservationProblem,numeric-method}
\alias{eval_ferrier_importance,ConservationProblem,matrix-method}
\alias{eval_ferrier_importance,ConservationProblem,data.frame-method}
\alias{eval_ferrier_importance,ConservationProblem,Spatial-method}
\alias{eval_ferrier_importance,ConservationProblem,sf-method}
\alias{eval_ferrier_importance,ConservationProblem,Raster-method}
\title{Evaluate solution importance using Ferrier scores}
\usage{
eval_ferrier_importance(x, solution)

\S4method{eval_ferrier_importance}{ConservationProblem,numeric}(x, solution)

\S4method{eval_ferrier_importance}{ConservationProblem,matrix}(x, solution)

\S4method{eval_ferrier_importance}{ConservationProblem,data.frame}(x, solution)

\S4method{eval_ferrier_importance}{ConservationProblem,Spatial}(x, solution)

\S4method{eval_ferrier_importance}{ConservationProblem,sf}(x, solution)

\S4method{eval_ferrier_importance}{ConservationProblem,Raster}(x, solution)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} (i.e. \code{\linkS4class{ConservationProblem}}) object.}

\item{solution}{\code{numeric}, \code{matrix}, \code{data.frame},
\code{\linkS4class{Raster}}, \code{\linkS4class{Spatial}},
or \code{\link[sf:sf]{sf::sf()}} object.
The argument should be in the same format as the planning unit cost
data in the argument to \code{x}.
See the Solution format section for more information.}
}
\value{
A \code{matrix}, \code{\link[tibble:tibble]{tibble::tibble()}},
\code{\linkS4class{RasterLayer}}, or
\code{\linkS4class{Spatial}} object containing the scores for each
planning unit selected in the solution.
Specifically, the returned object is in the
same format (except if the planning units are a \code{numeric} vector) as the
planning unit data in the argument to \code{x}.
}
\description{
Calculate importance scores for planning units selected in
a solution following Ferrier \emph{et al.} (2000).
}
\details{
Importance scores are reported separately for each feature within
each planning unit. Additionally, a total importance score is also
calculated as the sum of the scores for each feature.
Note that this function only works for problems with
a minimum set objective and a single zone.
It will throw an error for problems that do not meet this criteria.

\strong{Please note that
the mathematical formulation for computing these scores needs verification,
and so this functionality should be considered experimental at this point in
time.}
}
\section{Notes}{

In previous versions, the documentation for this function had a warning
indicating that the mathematical formulation for this function required
verification. The mathematical formulation for this function has since
been corrected and verified, so now this function is recommended
for general use.
}

\section{Solution format}{

Broadly speaking, the argument to \code{solution} must be in the same format as
the planning unit data in the argument to \code{x}.
Further details on the correct format are listed separately
for each of the different planning unit data formats:

\describe{

\item{\code{x} has \code{numeric} planning units}{The argument to \code{solution} must be a
\code{numeric} vector with each element corresponding to a different planning
unit. It should have the same number of planning units as those
in the argument to \code{x}. Additionally, any planning units missing
cost (\code{NA}) values should also have missing (\code{NA}) values in the
argument to \code{solution}.
}

\item{\code{x} has \code{matrix} planning units}{The argument to \code{solution} must be a
\code{matrix} vector with each row corresponding to a different planning
unit, and each column correspond to a different management zone.
It should have the same number of planning units and zones
as those in the argument to \code{x}. Additionally, any planning units
missing cost (\code{NA}) values for a particular zone should also have a
missing (\code{NA}) values in the argument to \code{solution}.
}

\item{\code{x} has \code{\linkS4class{Raster}} planning units}{The argument to \code{solution}
be a \code{\linkS4class{Raster}} object where different grid cells (pixels) correspond
to different planning units and layers correspond to
a different management zones. It should have the same dimensionality
(rows, columns, layers), resolution, extent, and coordinate reference
system as the planning units in the argument to \code{x}. Additionally,
any planning units missing cost (\code{NA}) values for a particular zone
should also have missing (\code{NA})  values in the argument to \code{solution}.
}

\item{\code{x} has \code{data.frame} planning units}{The argument to \code{solution} must
be a \code{data.frame} with each column corresponding to a different zone,
each row corresponding to a different planning unit, and cell values
corresponding to the solution value. This means that if a \code{data.frame}
object containing the solution also contains additional columns, then
these columns will need to be subsetted prior to using this function
(see below for example with \code{\link[sf:sf]{sf::sf()}} data).
Additionally, any planning units missing cost
(\code{NA}) values for a particular zone should also have missing (\code{NA})
values in the argument to \code{solution}.
}

\item{\code{x} has \code{\linkS4class{Spatial}} planning units}{The argument to \code{solution}
must be a \code{\linkS4class{Spatial}} object with each column corresponding to a
different zone, each row corresponding to a different planning unit, and
cell values corresponding to the solution value. This means that if the
\code{\linkS4class{Spatial}} object containing the solution also contains additional
columns, then these columns will need to be subsetted prior to using this
function (see below for example with \code{\link[sf:sf]{sf::sf()}} data).
Additionally, the argument to \code{solution} must also have the same
coordinate reference system as the planning unit data.
Furthermore, any planning units missing cost
(\code{NA}) values for a particular zone should also have missing (\code{NA})
values in the argument to \code{solution}.
}

\item{\code{x} has \code{\link[sf:sf]{sf::sf()}} planning units}{The argument to \code{solution} must be
a \code{\link[sf:sf]{sf::sf()}} object with each column corresponding to a different
zone, each row corresponding to a different planning unit, and cell values
corresponding to the solution value. This means that if the
\code{\link[sf:sf]{sf::sf()}} object containing the solution also contains additional
columns, then these columns will need to be subsetted prior to using this
function (see below for example).
Additionally, the argument to \code{solution} must also have the same
coordinate reference system as the planning unit data.
Furthermore, any planning units missing cost
(\code{NA}) values for a particular zone should also have missing (\code{NA})
values in the argument to \code{solution}.
}
}
}

\examples{
# seed seed for reproducibility
set.seed(600)

# load data
data(sim_pu_raster, sim_features)

# create minimal problem with binary decisions
p1 <- problem(sim_pu_raster, sim_features) \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.1) \%>\%
      add_binary_decisions() \%>\%
      add_default_solver(gap = 0, verbose = FALSE)
\dontrun{
# solve problem
s1 <- solve(p1)

# print solution
print(s1)

# plot solution
plot(s1, main = "solution", axes = FALSE, box = FALSE)

# calculate importance scores using Ferrier et al. 2000 method
fs1 <- eval_ferrier_importance(p1, s1)

# print importance scores,
# each planning unit has an importance score for each feature
# (as indicated by the column names) and each planning unit also
# has an overall total importance score (in the "total" column)
print(fs1)

# plot total importance scores
plot(fs1, main = "Ferrier scores", axes = FALSE, box = FALSE)

# create minimal problem with polygon (sf) planning units
p2 <- problem(sim_pu_sf, sim_features, cost_column = "cost") \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.05) \%>\%
      add_binary_decisions() \%>\%
      add_default_solver(gap = 0, verbose = FALSE)

# solve problem
s2 <- solve(p2)

# print solution
print(s2)

# plot solution
plot(s2[, "solution_1"], main = "solution")

# calculate importance scores
fs2 <- eval_ferrier_importance(p2, s2[, "solution_1"])

# plot importance scores
plot(fs2, main = "Ferrier scores")

}

}
\references{
Ferrier S, Pressey RL, and Barrett TW (2000) A new predictor of the
irreplaceability of areas for achieving a conservation goal, its application
to real-world planning, and a research agenda for further refinement.
\emph{Biological Conservation}, 93: 303--325.
}
\seealso{
See \link{importance} for an overview of all functions for evaluating
the importance of planning units selected in a solution.

Other importances: 
\code{\link{eval_rare_richness_importance}()},
\code{\link{eval_replacement_importance}()}
}
\concept{importances}
