% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.r
\name{plot.preference.trial}
\alias{plot.preference.trial}
\title{Plot the effect sizes of a preference trial}
\usage{
\method{plot}{preference.trial}(x, ...)
}
\arguments{
\item{x}{an object of class preference.trial.}

\item{...}{any other parameters (this is currently not used).}
}
\description{
The plot() function visualizes the change in the
preference effect, the selection effect, or both as a function of the
total sample size of the trial. If the preference effect varies but the
selection effect does not, then it plots the preference effect by the
total sample size. Similarly if the selection effect varies but not the
preference effect then selection effect vs total sample size is shown.
When both preference and selection effect vary then the selection effect
is shown conditioned on the given preference effects.

It is assumed that the set of trial provided as a parameter are related
and are comparable. For example, the function does not check to if
the strata are the same for all trials. If some other visualization is
required then the user is reminded that a preference.trial object is
a data frame and can be visualized in the usual way.
}
\examples{

# Plot trials with fixed power and varying preference effect.
trials <- pt_from_power(power = 0.8, pref_effect = seq(0.5, 2, by = 0.1), 
                        selection_effect = 1, treatment_effect = 1, 
                        sigma2 = 1, pref_prop = 0.6)
plot(trials)
 
# Plot trials with fixed power and varying selection effect.
trials <- pt_from_power(power = 0.8, pref_effect = 1,
                        selection_effect = seq(0.5, 2, by = 0.1), 
                        treatment_effect = 1, sigma2 = 1, pref_prop = 0.6)
plot(trials)

# Plot trials with fixed power and varying preference and 
# selection effects.

# the selection effects of interest
selection_effects <- rep(seq(0.5, 2, by = 0.1), 4)

# the preference effects to condition on
pref_effects <- rep(seq(0.4, 1, by = 0.2), 
                    each = length(selection_effects)/4)

trials <- pt_from_power(power = 0.8, pref_effect = pref_effects,
                        selection_effect = selection_effects,
                        treatment_effect = 1, sigma2 = 1, pref_prop = 0.6)
plot(trials)
 

}
