% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{c2_dat4}
\alias{c2_dat4}
\title{Cross-classified data (example 4)}
\format{
A \code{data.frame} with 6 rows and 3 columns:
\describe{
  \item{y_ijk}{observations}
  \item{a}{treatment a}
  \item{b}{treatment b}
}
}
\usage{
c2_dat4
}
\description{
c2_dat4 contains data that was sampled from an unbalanced cross-classified design.
}
\examples{

# loading lme4
library(lme4)

# Fitting a random effects model based on c2_dat_1
fit <- lmer(y_ijk~(1|a)+(1|b)+(1|a:b), c2_dat1)
summary(fit)

#----------------------------------------------------------------------------

### Prediction interval using c2_dat4 as future data

# c2_dat4 has no replication for b. Hence the list of design matrices can not be
# generated by lme4::lFormula() and has to be provided by hand via futmat_list.

c2_dat4

# Build a list containing the design matrices

fml <- vector(length=4, "list")

names(fml) <- c("a:b", "b", "a", "Residual")

fml[["a:b"]] <- matrix(nrow=6, ncol=2, data=c(1,1,0,0,0,0, 0,0,1,1,1,1))

fml[["b"]] <- matrix(nrow=6, ncol=1, data=c(1,1,1,1,1,1))

fml[["a"]] <- matrix(nrow=6, ncol=2, data=c(1,1,0,0,0,0, 0,0,1,1,1,1))

fml[["Residual"]] <- diag(6)

fml

# Please note, that the design matrix for the interaction term a:b is also
# provided even there is no replication for b, since it is believed that
# both, the historical and the future data descent from the same data generating
# process.

# Calculate the PI
pred_int <- lmer_pi_futmat(model=fit, futmat_list=fml, alternative="both", nboot=100)
summary(pred_int)
# Please note that nboot was set to 100 in order to decrease computing time
# of the example. For a valid analysis set nboot=10000.

}
\keyword{datasets}
