% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predhybrid.R
\name{predhybrid}
\alias{predhybrid}
\title{Predict the Performance of Hybrids}
\usage{
predhybrid(inbred_gen, hybrid_phe, predparent_gen = inbred_gen,
  fix = NULL, fixnew = NULL, model = "AD", select = "all",
  number = NULL)
}
\arguments{
\item{inbred_gen}{a matrix for genotypes of parental lines in numeric format, coded as 1, 0 and -1. The row.names of inbred_gen must be provied. It can be obtained from the original genotype using  \code{\link{convertgen}} function.}

\item{hybrid_phe}{a data frame with three columns. The first column and the second column are the names of male and female parents of the corresponding hybrids, respectively; the third column is the phenotypic values of hybrids.
The names of male and female parents must match the rownames of inbred_gen. Missing (NA) values are not allowed.}

\item{predparent_gen}{a matrix for genotypes of a given parental lines. All potential crosses derived from these parental lines will be predicted. Default is the same as inbred_gen.}

\item{fix}{a design matrix of the fixed effects for the parental lines. If not passed, a vector of ones is added for the intercept.}

\item{fixnew}{a design matrix of the fixed effects for all potential crosses. If not passed, a vector of ones is added for the intercept.}

\item{model}{the model of prediction. There are two options: model = "AD" for the additive-dominance model, model = "A" for the additive model. Default is model = "AD".}

\item{select}{the selection of hybrids based on the prediction results. There are three options: select = "all", which selects all potential crosses.
select = "top", which selects the top n crosses. select = "top", which selects the bottom n crosses. The n is determined by the param number.}

\item{number}{the number of selected top or bottom hybrids, only when select = "top" or select = "bottom".}
}
\value{
A data frame of prediction result with two columns. The first column denotes the names of male and female parents of the predicted hybrids,
and the second column denotes the phenotypic values of the predicted hybrids.
}
\description{
Predict all potential crosses of a given set of parents using a subset of crosses as the training sample.
}
\examples{
\donttest{
## load example data from hypred package
data(hybrid_phe)
data(input_geno)
inbred_gen <- convertgen(input_geno, type = "hmp2")

## to save time, only predict 45 crosses derived from the first 10 lines of parental lines
## select all hybrids with additive-dominance model
pred1 <- predhybrid(inbred_gen, hybrid_phe, predparent_gen = inbred_gen[c(1:10),], model = "AD")

## select top 20 hybrids with additive model
pred2 <- predhybrid(inbred_gen, hybrid_phe, predparent_gen = inbred_gen[c(1:10),],
select = "top", number = 10, model = "A")
}
}
