% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_position_plots.R
\name{document_position_plots}
\alias{document_position_plots}
\title{Document Position Plots}
\usage{
document_position_plots(positions_list, num_cols = 10, colors = NULL,
  decision_colors = NULL)
}
\arguments{
\item{positions_list}{A list of scaled document positions generated by
the `scaling_comparison()` and returned in the `$scaled_positions` field.}

\item{num_cols}{The number of columns to use in combining plots into a
a large tiled plot..}

\item{colors}{Optional vector of document colors to distinguish groups.}

\item{decision_colors}{Defaults to NULL, if desired, the user
should provide a vector of logical values of length equal to the number of
preprocessing decisions. Can be used to bifurcate the points within a
single plot to show the effects of a particular decision. Points in the
TRUE class will be colors BLUE and those in the FALSE class will be colored
red.}
}
\value{
A list of ggplot2 objects.
}
\description{
Plot Procrustes transformed scaled positions of each document
under each preprocessing regime.
}
\examples{
\dontrun{
# *** This function is used automatically inside of the preText() function.
# load the package
library(preText)
# load in the data
data("UK_Manifestos")
# preprocess data
preprocessed_documents <- factorial_preprocessing(
    UK_Manifestos,
    use_ngrams = TRUE,
    infrequent_term_threshold = 0.02,
    verbose = TRUE)
# scale documents
scaling_results <- scaling_comparison(preprocessed_documents$dfm_list,
                                      dimensions = 2,
                                      distance_method = "cosine",
                                      verbose = TRUE)
# plot scaled positions
document_position_plots(scaling_results$scaled_positions,
                        num_cols = 10,
                        colors = NULL,
                        decision_colors = NULL)
}
}
