% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_coefficient_plot.R
\name{regression_coefficient_plot}
\alias{regression_coefficient_plot}
\title{Regression Coefficient Plot}
\usage{
regression_coefficient_plot(data, text_size = 1, remove_intercept = FALSE,
  title = "")
}
\arguments{
\item{data}{A data.frame produced by the `preprocessing_choice_regression()`
function, or a list created by the `preText()` function.}

\item{text_size}{The size of the text to be displayed. Defaults to 1.}

\item{remove_intercept}{Logical indicating whether intercept coefficient should
be plotted. Defaults to FALSE.}

\item{title}{The title the user wishes to give the lot, which will be displayed
instead of the axis title.}
}
\value{
A plot
}
\description{
Easy plotting for multiple regression results on same axes.
}
\examples{
\dontrun{
# load the package
library(preText)
# load in the data
data("UK_Manifestos")
# preprocess data
preprocessed_documents <- factorial_preprocessing(
    UK_Manifestos,
    use_ngrams = TRUE,
    infrequent_term_threshold = 0.02,
    verbose = TRUE)
# run preText
preText_results <- preText(
    preprocessed_documents,
    dataset_name = "Inaugural Speeches",
    distance_method = "cosine",
    num_comparisons = 100,
    verbose = TRUE)
# generate regression results
regression_coefficient_plot(preText_results,
                            remove_intercept = TRUE)
}
}

