% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preText_score_plot.R
\name{preText_score_plot}
\alias{preText_score_plot}
\title{preText specification plot}
\usage{
preText_score_plot(preText_results, display_raw_rankings = FALSE,
  remove_labels = FALSE, num_docs = NULL, text_size = 1)
}
\arguments{
\item{preText_results}{The output from the `preText_test()` or
`preText()` functions.}

\item{display_raw_rankings}{Logical indicating whether raw ranking
differences should be displayed (as opposed to relative differences).}

\item{remove_labels}{Option to remove preprocessing step labels. Defaults to
FALSE.}

\item{num_docs}{If display_raw_rankings = TRUE, the number of documents in
the corpus.}

\item{text_size}{The `cex` for text in dot plot generated by function.
Defaults to 1.}
}
\value{
A plot
}
\description{
preText plots for each preprocessing specification.
}
\examples{
\dontrun{
# load the package
library(preText)
# load in the data
data("UK_Manifestos")
# preprocess data
preprocessed_documents <- factorial_preprocessing(
    UK_Manifestos,
    use_ngrams = TRUE,
    infrequent_term_threshold = 0.02,
    verbose = TRUE)
# run preText
preText_results <- preText(
    preprocessed_documents,
    dataset_name = "Inaugural Speeches",
    distance_method = "cosine",
    num_comparisons = 100,
    verbose = TRUE)
# generate preText score plot
preText_score_plot(preText_results)
}
}

