% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{bsnullinteract}
\alias{bsnullinteract}
\title{Compute boostrapped null interaction models}
\usage{
bsnullinteract(object, nsamp = 10, seed = 42)
}
\arguments{
\item{object}{object of class \code{\link{pre}}.}

\item{nsamp}{numeric. Number of bootstrapped null interaction models to be 
derived.}

\item{seed}{numeric. Random seed to be used (for reproducability).}
}
\value{
A list of null interaction models, to be used as input for 
\code{\link{interact}}.
}
\description{
\code{bsnullinteract} calculates null interaction models on bootstrapped 
datasets, for deriving a reference distribution of the test statistic 
calculated with \code{\link{interact}}.
}
\details{
Computationally intensive. Progress info is printed to command line.
}
\examples{
\donttest{
airq.ens <- pre(Ozone ~ ., data=airquality[complete.cases(airquality),])
nullmods <- bsnullinteract(airq.ens)}
}

