% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build_image}
\alias{build_image}
\title{Build a Docker image}
\usage{
build_image(
  pkg_path = ".",
  img_path = NULL,
  cache = TRUE,
  tag = NULL,
  build = TRUE
)
}
\arguments{
\item{pkg_path}{Path to the package directory. Default is \code{"."} for the current working directory, which assumes developer is working in R package root. However, this can be set to another path as needed.}

\item{img_path}{Path to the write the docker image definition contents. The default \code{NULL} will use \verb{docker/} as a subdirectory of the \code{pkg_path}.}

\item{cache}{Logical; should caching be used? Default \code{TRUE}. Set to \code{FALSE} to use \code{--no-cache} in \verb{docker build}.}

\item{tag}{Image tag to use; default is \code{NULL} and the image will be tagged with package name version from \link{pkg_info}.}

\item{build}{Logical as to whether or not the image should be built. Default is \code{TRUE}, and if \code{FALSE} the \verb{docker build} command will be messaged.  Setting \code{build=FALSE} could be useful if additional \verb{docker build} options or different tags are desired. In either case the \verb{docker build} command will be returned invisibly.}
}
\value{
Invisibly returns the \verb{docker build} command. Primarily called for its side effects, which runs the \verb{docker build} as a system command.
}
\description{
Builds a Docker image created by \link{use_docker} or \link{add_dockerfile}. This function is run as part of \link{use_docker} when \code{build = TRUE} is set, but can be used on its own.
}
\examples{
\dontrun{
# Specify path to example package source and copy to tempdir()
# Note that in practice you do not need to copy to a tempdir()
# And in fact it may be easiest to use pracpac relative to your package directory root
ex_pkg_src <- system.file("hellow", package = "pracpac", mustWork = TRUE)
file.copy(from = ex_pkg_src, to = tempdir(), recursive = TRUE)

# Run use_docker to create Docker directory and assets for the example package
use_docker(pkg_path = file.path(tempdir(), "hellow"))

# Build the image
build_image(pkg_path = file.path(tempdir(), "hellow"))
# Or construct the image build command without building
build_cmd <- build_image(pkg_path = file.path(tempdir(), "hellow"), build=FALSE)
build_cmd
}
}
