% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotResidualPlot.R
\name{plot_residual_plot}
\alias{plot_residual_plot}
\title{Create residual plot}
\usage{
plot_residual_plot(
  x,
  transformer,
  centre_width = NULL,
  show_original = TRUE,
  use_alpha = TRUE,
  use_absolute_deviation = TRUE,
  ggtheme = NULL
)
}
\arguments{
\item{x}{A vector with numeric values that should be transformed to
normality.}

\item{transformer}{A transformer object created using
\code{find_transformation_parameters}.}

\item{centre_width}{A numeric value between 0.0 and 1.0 that describes the
width of the centre of the data. Can be NULL.}

\item{show_original}{Show residuals for original, untransformed, data in
addition to transformed data.}

\item{use_alpha}{Use transparency for points in case the data contains many
instances.}

\item{use_absolute_deviation}{Plot absolute deviation instead of residuals.}

\item{ggtheme}{\code{ggplot2} theme to use for the plot. If not provided,
\code{ggplot2::theme_light} is used.}
}
\value{
A \code{ggplot2} plot object for a Q-Q plot.
}
\description{
Create a figure that plots the residuals of the data. These residuals are the
difference between expected normal quantiles and observed quantiles.
}
\examples{
x <- exp(stats::rnorm(1000))
transformer <- find_transformation_parameters(
  x = x,
  method = "box_cox"
)

if (rlang::is_installed("ggplot2")) {
  plot_residual_plot(
    x = x,
    transformer = transformer
  )

  # Plot only central 80\% of the data.
  plot_residual_plot(
    x = x,
    transformer = transformer,
    centre_width = 0.80,
    show_original = FALSE
  )
}
}
