% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_conexp.R, R/def_conlorm.R, R/def_conpl.R, R/def_conweibull.R, R/def_disexp.R, R/def_dislnorm.R, R/def_displ.R, R/def_dispois.R
\docType{class}
\name{conexp-class}
\alias{conexp}
\alias{conexp-class}
\alias{conlnorm}
\alias{conlnorm-class}
\alias{conpl}
\alias{conpl-class}
\alias{conweibull}
\alias{conweibull-class}
\alias{disexp}
\alias{disexp-class}
\alias{dislnorm}
\alias{dislnorm-class}
\alias{displ}
\alias{displ-class}
\alias{dispois}
\alias{dispois-class}
\title{Heavy-tailed distributions}
\arguments{
\item{...}{The object is typically created by passing 
data using the \code{dat} field. 
Each field has standard setters and getters.}
}
\value{
a reference object
}
\description{
The \pkg{poweRlaw} package supports a number of distributions:
\describe{
\item{displ}{Discrete power-law}
\item{dislnorm}{Discrete log-normal}
\item{dispois}{Discrete Poisson}
\item{disexp}{Discrete Exponential}
\item{conpl}{Continuous power-law}
\item{conlnorm}{Continuous log-normal}
\item{conexp}{Continuous exponential}}
Each object inherits the \code{discrete_distribution} or the \code{ctn_distribution} class.
}
\section{Fields}{


Each distribution object has four fields. However, the object 
is typically created by passing 
data, to the \code{dat} field. Each field has standard 
setters and getters. See examples below
\describe{
\item{dat}{The data set.}
\item{xmin}{The lower threshold, xmin. Typically set after initialisation. 
For the continuous  power-law, xmin >= 0 for the discrete 
distributions, xmin >0}
\item{pars}{A parameter vector. Typically set after initialisation. Note the lognormal distribution has two parameters.}
\item{internal}{A list. This list differs between objects and shouldn't be altered.}}
}

\section{Copying objects}{

Distribution objects are reference classes. This means that when we copy
objects, we need to use the \code{copy} method, i.e. \code{obj$copy()}. 
See the examples below for further details.
}
\examples{
##############################################################
#Load data and create distribution object                    #
##############################################################
data(moby)
m = displ$new(moby)

##############################################################
#Xmin is initially the smallest x value                      #
##############################################################
m$getXmin()
m$getPars()

##############################################################
#Set Xmin and parameter                                      #
##############################################################
m$setXmin(2)
m$setPars(2)


##############################################################
#Plot the data and fitted distribution                       #
##############################################################
plot(m)
lines(m)
##############################################################
#Copying                                                     #
##############################################################
## Shallow copy
m_cpy = m
m_cpy$setXmin(5)
m$getXmin()
## Instead
m_cpy = m$copy()
}

