% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_tuning.R
\name{plotPerformanceVsParams}
\alias{plotPerformanceVsParams}
\title{Plot performance of portfolio function vs choice of parameters}
\usage{
plotPerformanceVsParams(
  bt_all_portfolios,
  params_subset = NULL,
  name_performance = "Sharpe ratio",
  summary_fun = median
)
}
\arguments{
\item{bt_all_portfolios}{Backtest results as produced by the function \code{\link{portfolioBacktest}}.}

\item{params_subset}{List of named parameters with a subset of the values to be considered. By 
default all the possible values will be considered.}

\item{name_performance}{String with the name of the performance measure to be used.}

\item{summary_fun}{Summary function to be employed (e.g., median or mean). Defult is median.}
}
\description{
Portfolio functions usually contain some parameters that can be tuned. 
After generating multiple versions of a portfolio function with randomly chosen parameters
with the function \code{\link{genRandomFuns}} and doing the backtesting, this function
can be used to plot the performance vs choice of parameters.
}
\examples{
\donttest{
library(portfolioBacktest)

# define GMVP with parameters "delay", "lookback", and "regularize"
GMVP_portfolio_fun <- function(dataset, ...) {
  prices <- tail(lag(dataset$adjusted, delay), lookback)
  X <- diff(log(prices))[-1]
  Sigma <- cov(X)
  if (regularize)
    Sigma <- Sigma + 0.01*diag(ncol(Sigma))
  # design GMVP
  w <- solve(Sigma, rep(1, ncol(Sigma)))
  return(w/sum(w))
}

# generate the functions with random parameters
portfolio_list <- genRandomFuns(portfolio_fun = GMVP_portfolio_fun, 
                                params_grid = list(lookback = c(100, 120, 140, 160),
                                                   delay = c(0, 5, 10, 15, 20),
                                                   regularize = c(FALSE, TRUE)),
                                name = "GMVP", 
                                N_funs = 40)
                                
# backtest portfolios
bt <- portfolioBacktest(portfolio_list, dataset10)

# plot
plotPerformanceVsParams(bt)
plotPerformanceVsParams(bt, params_subset = list(regularize = TRUE))
plotPerformanceVsParams(bt, params_subset = list(delay = 5))
plotPerformanceVsParams(bt, params_subset = list(delay = 5, regularize = TRUE))
}

}
\seealso{
\code{\link{genRandomFuns}}
}
\author{
Daniel P. Palomar and Rui Zhou
}
