% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlantData.R
\name{shrub_cover}
\alias{shrub_cover}
\title{Generate percent cover from Portal plant transect data}
\usage{
shrub_cover(path = "~", type = "Shrubs", plots = "all",
  unknowns = FALSE, correct_sp = TRUE)
}
\arguments{
\item{path}{path to location of downloaded Portal data; or "repo" to
retrieve data from github repo}

\item{type}{specify subset of species;
If type=Annuals, removes all non-annual species.
If type=Summer Annuals, returns all annual species that can be found in the summer
If type=Winter Annuals, returns all annual species that can be found in the winter
If type=Non-woody, removes shrub and subshrub species
If type=Perennials, returns all perennial species (includes shrubs and subshrubs)
If type=Shrubs, returns only shrubs and subshrubs}

\item{plots}{specify subset of plots; can be a vector of plots, or specific
sets: "all" plots or "Longterm" plots (plots that have had the same
treatment for the entire time series)}

\item{unknowns}{either removes all individuals not identified to species
(unknowns = FALSE) or sums them in an additional column (unknowns = TRUE)}

\item{correct_sp}{correct species names suspected to be incorrect in early data (T/F)}
}
\value{
a data.frame of percent cover and mean height
}
\description{
This function calculates percent cover from transect data.
It handles the pre-2015 data differently from the current transects,
becase they are collected differently. But it returns a single time-series
with all years of transect data available. It also returns mean height
beginning in 2015.
}
