% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr.R
\name{dr}
\alias{dr}
\title{Calculate damping ratio}
\usage{
dr(A, return.time = FALSE, x = 10)
}
\arguments{
\item{A}{a square, irreducible, non-negative numeric matrix of any dimension.}

\item{return.time}{(optional) a logical argument determining whether an 
estimated convergence time should be returned.}

\item{x}{(optional) the logarithm used in determining estimated time to 
convergence (see details).}
}
\value{
If \code{return.time=FALSE}, the damping ratio of \code{A}.\cr
If \code{return.time=TRUE}, a list containing components:
\describe{
 \item{dr}{the damping ratio of \code{A}}
 \item{t}{the estimated time to convergence.}
}
}
\description{
Calculate the damping ratio of a given population matrix projection model.
}
\details{
The damping ratio is calculated as the ratio of the dominant eigenvalue to 
the modulus of the largest subdominant eigenvalue. Time to convergence can 
be estmimated by calculating \code{log(dr)/log(x)}, which is the time taken 
for the dominant eigenvalue to become \code{x} times larger than the largest 
subdominant eigenvalue.
}
\examples{
  # Create a 3x3 PPM
  A <- matrix(c(0,1,2,0.5,0.1,0,0,0.6,0.6), byrow=TRUE, ncol=3)

  # Calculate damping ratio
  dr(A)

  # Calculate damping ratio and time to convergence using a 
  # multiple of 10
  dr(A, return.time=TRUE, x=10)

}
\references{
\itemize{
 \item Caswell (2001) Matrix Population Models 2nd. ed. Sinauer.
 \item Stott et al. (2010) Ecol. Lett., 14, 959-970.
}
}
\seealso{
Other ConvergenceMeasures: \code{\link{convt}},
  \code{\link{truelambda}}
}
\concept{
converge convergence resilience stability
}
