% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_algorithms.R
\name{estimation_algorithms}
\alias{estimation_algorithms}
\title{Estimation algorithms for POMP models.}
\description{
\pkg{pomp} currently implements the following algorithms for estimating model parameters:
\itemize{
\item \link[=mif2]{iterated filtering (IF2)}
\item \link[=pmcmc]{particle Markov chain Monte Carlo (PMCMC)}
\item \link[=abc]{approximate Bayesian computation (ABC)}
\item \link[=probe.match]{probe-matching via synthetic likelihood}
\item \link[=nlf]{nonlinear forecasting}
\item \link[=spect.match]{power-spectrum matching}
\item \link[=bsmc2]{Liu-West Bayesian sequential Monte Carlo}
\item \link[=kalman]{Ensemble and ensemble-adjusted Kalman filters}
}
}
\details{
Help pages detailing each estimation algorithm are provided.
}
\seealso{
\link[=basic_components]{basic model components},
\link[=workhorses]{workhorse functions},
\link[=elementary_algorithms]{elementary algorithms}.

More on \pkg{pomp} estimation algorithms:
\code{\link{abc}()},
\code{\link{bsmc2}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{nlf}},
\code{\link{pmcmc}()},
\code{\link{pomp-package}},
\code{\link{probe.match}},
\code{\link{spect.match}}
}
\concept{estimation_methods}
