% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_action.R
\name{optimal_action}
\alias{optimal_action}
\title{Optimal action for a belief}
\usage{
optimal_action(model, belief = NULL, epoch = 1)
}
\arguments{
\item{model}{a solved \link{POMDP}.}

\item{belief}{The belief (probability distribution over the states) as a
vector or a matrix with multiple belief states as rows. If \code{NULL}, then the initial belief of the
model is used.}

\item{epoch}{what epoch of the policy should be used. Use 1 for converged policies.}
}
\value{
The name of the optimal action.
}
\description{
Determines the optimal action for a policy (solved POMDP) for a given belief
at a given epoch.
}
\examples{
data("Tiger")
Tiger

sol <- solve_POMDP(model = Tiger)

# these are the states
sol$states

# belief that tiger is to the left
optimal_action(sol, c(1, 0))
optimal_action(sol, "tiger-left")

# belief that tiger is to the right
optimal_action(sol, c(0, 1))
optimal_action(sol, "tiger-right")

# belief is 50/50
optimal_action(sol, c(.5, .5))
optimal_action(sol, "uniform")

# the POMDP is converged, so all epoch give the same result.
optimal_action(sol, "tiger-right", epoch = 10)

}
\seealso{
Other policy: 
\code{\link{estimate_belief_for_nodes}()},
\code{\link{plot_belief_space}()},
\code{\link{plot_policy_graph}()},
\code{\link{policy}()},
\code{\link{policy_graph}()},
\code{\link{projection}()},
\code{\link{reward}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()},
\code{\link{value_function}()}
}
\author{
Michael Hahsler
}
\concept{policy}
