% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessory_functions.R
\name{fast_IBD}
\alias{fast_IBD}
\title{Extremely fast estimation of identity-by-descent (IBD) probabilities.}
\usage{
fast_IBD(
  phased_maplist,
  dosage_matrix,
  map_function = "haldane",
  ploidy,
  ploidy2 = NULL,
  fix_threshold = 0.1,
  factor_dist = 1,
  ncores = 1
)
}
\arguments{
\item{phased_maplist}{A list of linkage maps calculated by \code{polymapR::create_phased_maplist}}

\item{dosage_matrix}{An integer matrix with markers in rows and individuals in columns}

\item{map_function}{The mapping function to calculate recombination frequency based on map distance (haldane or kosambi)}

\item{ploidy}{Ploidy level of parents or of the first parent}

\item{ploidy2}{Ploidy level of the second parent. By default \code{NULL}, if parents have equal ploidy levels.}

\item{fix_threshold}{The threshold to fix the IBD probabilities while correcting for the sum of probabilities.}

\item{factor_dist}{Factor to increase or decrease the recombination frequencies as calculated from the map distances.}

\item{ncores}{Number of cores to use for multi-core processing.}
}
\value{
A nested list (with the same length as phased_maplist). Each list element contains the following items:
\item{IBDtype}{Always "haplotypeIBD" for the output of this function}
\item{IBDarray}{An array of IBD probabilities. The dimensions of the array are: markers, homologues and individuals.}
\item{map}{Integrated linkage map positions of markers used in IBD calculation}
\item{parental_phase}{The parental marker phasing, coded in 1 and 0's}
\item{biv_dec}{\code{NULL}}
\item{gap}{The gap size used in IBD interpolation, by default \code{NULL}. See \code{\link{spline_IBD}}}
\item{genocodes}{\code{NULL}}
\item{pairing}{\code{NULL}}
\item{ploidy}{ploidy of parent 1}
\item{ploidy2}{ploidy of parent 2}
\item{method}{The method used, here "heur" (heuristic)}
\item{error}{The error prior used, not relevant here thus \code{NULL}}
}
\description{
The method of "quick-and-dirty" IBD estimation was originally developed by Bourke (2014) for tetraploid data only, and was subsequently
generalised by van Geest et al. (2017). Can be useful for a first quick analysis, particularly in large hexaploid datasets. However, the higher accuracy of IBD
probabilities generated by \code{\link{hmm_IBD}} makes that function the preferred choice.
}
\examples{
data("phased_maplist.4x","SNP_dosages.4x")
IBD_list.4x <- fast_IBD(phased_maplist = phased_maplist.4x,
                        dosage_matrix = SNP_dosages.4x,
                        ploidy = 4)
}
\references{
Bourke P.M. (2014) QTL analysis in polyploids: Model testing and power calculations. Wageningen University (MSc thesis)
}
