% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwd.R
\name{bw_mrot_polysph}
\alias{bw_mrot_polysph}
\title{Marginal rule-of-thumb bandwidth selection for polyspherical kernel
density estimator}
\usage{
bw_mrot_polysph(X, d, kernel = 1, k = 10, upscale = FALSE, deriv = 0,
  kappa = NULL, ...)
}
\arguments{
\item{X}{a matrix of size \code{c(n, sum(d) + r)} with the sample.}

\item{d}{vector of size \code{r} with dimensions.}

\item{kernel}{kernel employed: \code{1} for von Mises--Fisher (default);
\code{2} for Epanechnikov; \code{3} for softplus.}

\item{k}{softplus kernel parameter. Defaults to \code{10.0}.}

\item{upscale}{rescale bandwidths to work on
\eqn{\mathcal{S}^{d_1}\times\cdots\times \mathcal{S}^{d_r}} and for
derivative estimation?
Defaults to \code{FALSE}. If \code{upscale = 1}, the order \code{n} is
upscaled. If \code{upscale = 2}, then also the kernel constant is upscaled.}

\item{deriv}{derivative order to perform the upscaling. Defaults to \code{0}.}

\item{kappa}{estimate of the concentration parameters. Computed if not
provided (default).}

\item{...}{further arguments passed to \code{\link[stats]{nlm}}.}
}
\value{
A vector of size \code{r} with the marginal optimal bandwidths.
}
\description{
Computes marginal (sphere by sphere) rule-of-thumb bandwidths
for the polyspherical kernel density estimator using a von Mises--Fisher
distribution as reference.
}
\examples{
n <- 100
d <- 1:2
kappa <- rep(10, 2)
X <- r_vmf_polysph(n = n, d = d, mu = r_unif_polysph(n = 1, d = d),
                   kappa = kappa)
bw_rot_polysph(X = X, d = d)$bw
bw_mrot_polysph(X = X, d = d)
}
