% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regions_class.R
\docType{class}
\name{regions}
\alias{regions}
\alias{regions-class}
\alias{as.regions}
\alias{as.data.table,regions-method}
\title{Regions of a CWB corpus.}
\usage{
as.regions(x)

\S4method{as.data.table}{regions}(x, values = NULL)
}
\arguments{
\item{x}{object of class \code{regions}}

\item{values}{values to assign to a column that will be added}
}
\description{
A coerce-method is available to coerce a \code{partition} object to a
\code{regions} object.
}
\section{Slots}{

\describe{
\item{\code{cpos}}{a two-column \code{data.table} that will include a "cpos_left" and "cpos_right" column}

\item{\code{corpus}}{the CWB corpus (character vector length 1)}

\item{\code{encoding}}{the encoding of the CWB corpus (character vector length 1)}
}}

\examples{
\donttest{
use("polmineR")
P <- partition("GERMAPARLMINI", date = "2009-11-12", speaker = "Jens Spahn")
R <- as.regions(P)
encode(R, sAttribute = "foo", values = "Jens")
}
}
